(function() {
  //    FILE:ChangePasswordView
  //    PROJECT:fw-mobile
  //    Created by Rafa Dorado on 2/18/13
  //    Farmerswife SL.
  define(['jquery', 'underscore', 'Handlebars', 'Backbone', "views/menu/MenuView", 'PrecompiledTemplates'], function($, _, Handlebars, Backbone, MenuView) {
    var ChangePasswordView;
    return ChangePasswordView = class ChangePasswordView extends Backbone.View {
      initialize(usr) {
        this.usr = usr;
        this.usr.on('password_updated', this.password_updated, this);
        this.usr.on('password_error', this.password_error, this);
        return this.oldP = '';
      }

      attributes() {
        return {
          'data-role': 'page',
          'data-name': 'ChangePasswordView'
        };
      }

      events() {
        return {
          'tap #id-btn-panel': 'btnPanelClicked',
          'tap #id-btn-submit-oldP': 'btnSubmitOldPassword',
          'tap #id-btn-submit-newP': 'btnSubmitNewPassword',
          'pageShow': 'pageShown'
        };
      }

      render() {
        var template;
        template = Handlebars.templates['ChangePasswordView'];
        this.$el.html(template());
        this.$el.attr('id', 'id-ChangePasswordView');
        this.addSidePanel();
        return this.$el;
      }

      //HANDLING OF SIDE PANEL AND NAVIGATION
      addSidePanel() {
        if (!MenuView) {
          MenuView = require("views/menu/MenuView");
        }
        this.panel = new MenuView(this.usr, this.obj);
        this.panel.render();
        return this.$el.append(this.panel.el);
      }

      pageShown(event) {
        $('#pwd-oldP').show();
        return $('#pwd-newP').hide();
      }

      btnPanelClicked(event) {
        return this.panel.btnPanelClicked(event);
      }

      btnSubmitOldPassword(event) {
        event.preventDefault();
        event.stopPropagation();
        this.oldP = $('#id-input-oldP').val();
        if (this.oldP === '') {
          $('#pwd-notification').html('Password cannot be empty');
          return $('#pwd-notification').show();
        } else {
          $('#pwd-oldP').hide();
          $(':input', '#pwd-newP').val('');
          return $('#pwd-newP').show();
        }
      }

      btnSubmitNewPassword(event) {
        var newP1, newP2;
        event.preventDefault();
        event.stopPropagation();
        newP1 = $('#id-input-newP-1').val();
        newP2 = $('#id-input-newP-2').val();
        if (newP1 === newP2) {
          return this.usr.set_user_password(this.oldP, newP1);
        } else {
          $('#pwd-notification').html('Password miss match, please try again');
          return $('#pwd-notification').show();
        }
      }

      password_updated() {
        $('#pwd-notification').html('Password Succesfully Changed');
        $('#pwd-notification').css('background', '#1abc9c');
        $('#pwd-notification').show();
        $('#pwd-oldP').hide();
        return $('#pwd-newP').hide();
      }

      password_error() {
        $('#pwd-notification').html(this.usr.server_message);
        $('#pwd-notification').show();
        $('#pwd-notification').css('background', '#FF3830');
        $(':input', '#pwd-oldP').val('');
        $('#pwd-oldP').show();
        return $('#pwd-newP').hide();
      }

    };
  });

}).call(this);
